/**
 * @license
 * Copyright 2020 Google LLC. All Rights Reserved.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =============================================================================
 */
import { env, ResizeBilinear } from '@tensorflow/tfjs-core';
import { ResizeBilinearProgram } from '../resize_bilinear_gpu';
import { ResizeBilinearPackedProgram } from '../resize_bilinear_packed_gpu';
export function resizeBilinear(args) {
    const { inputs, backend, attrs } = args;
    const { images } = inputs;
    const { alignCorners, halfPixelCenters, size } = attrs;
    const [newHeight, newWidth] = size;
    const program = env().getBool('WEBGL_PACK_IMAGE_OPERATIONS') ?
        new ResizeBilinearPackedProgram(images.shape, newHeight, newWidth, alignCorners, halfPixelCenters) :
        new ResizeBilinearProgram(images.shape, newHeight, newWidth, alignCorners, halfPixelCenters);
    return backend.runWebGLProgram(program, [images], 'float32');
}
export const resizeBilinearConfig = {
    kernelName: ResizeBilinear,
    backendName: 'webgl',
    kernelFunc: resizeBilinear
};
//# sourceMappingURL=data:application/json;base64,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